@ECHO OFF
set ERROR1=0
set ERROR1a=0
set ERROR1b=0
set ERROR2=0
set BINFILE=Not Found
cls
for %%i in (q24*.bin) do set BINFILE=%%i

:STEP1
	IF EXIST 2400.bin GOTO TWOFLASH
	ECHO.
	ECHO.   STEP 1: FLASHING MULTIBOOT IMAGE...
	ECHO.   FILE: %BINFILE%
	ECHO.

	flasutil /i /fb /o %BINFILE%
	if ERRORLEVEL 1 set ERROR1=1
	if not %ERROR1%==0 pause

GOTO STEP2

:TWOFLASH

	ECHO.
	ECHO.   STEP 1a: FLASHING 256KB MULTIBOOT IMAGE...
	ECHO.   FILE: %BINFILE% 
	ECHO.

	flasutil /i /f /o %BINFILE%
	if ERRORLEVEL 1 set ERROR1a=1
	if not %ERROR1a%==0 pause	

	ECHO.
	ECHO.   STEP 1b: FLASHING FIRMWARE IMAGE...
	ECHO.   FILE: 2400.BIN 
	ECHO.

	flasutil /i /fr /o 2400.bin
	if ERRORLEVEL 1 set ERROR1b=1
	if not %ERROR1b%==0 pause	


:STEP2
	cls
	ECHO.
	ECHO.   STEP 2: UPDATING VPD DATA...
	ECHO.

	vpd /a /u
	if ERRORLEVEL 1 set ERROR2=1
	if not %ERROR2%==0 pause

:END
	if not %ERROR1%==0 goto ERROR 	
	if not %ERROR1a%==0 goto ERROR
	if not %ERROR1b%==0 goto ERROR
	if not %ERROR2%==0 goto ERROR
	ECHO.
	ECHO.   HBA MULTI-BOOT/VPD UPDATE COMPLETE !
	ECHO.
	ECHO.   Please reboot the system for the changes to take effect.
goto EXIT

:ERROR
	ECHO.
	if not %ERROR1%==0 ECHO.   ERROR in STEP 1: FLASHING MULTIBOOT IMAGE...  	
	if not %ERROR1a%==0 ECHO.   ERROR in STEP 1a: FLASHING 256KB MULTIBOOT IMAGE...
	if not %ERROR1b%==0 ECHO.   ERROR in STEP 1b: FLASHING FIRMWARE IMAGE...
	if not %ERROR2%==0 ECHO.   ERROR in STEP 2: UPDATING VPD DATA...
	ECHO.
	ECHO.   HBA MULTI-BOOT/VPD UPDATE INCOMPLETE!!

:EXIT
	set ERROR1=
	set ERROR1a=
	set ERROR1b=
	set ERROR2=
	set BINFILE=
	ECHO.
